IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTAGEM_DIARIA]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTAGEM_DIARIA]
GO
GO 
--EXEC P_EST_PROD_CPL_MOVIMENTACAO_CONTAGEM_DIARIA 1,9,175,'2017-03-29'
CREATE PROCEDURE P_EST_PROD_CPL_MOVIMENTACAO_CONTAGEM_DIARIA @CD_EMP INT, @CD_FILIAL INT, @CD_GRP_CONTAGEM INT, @DT_CONTAGEM DATETIME
AS
CREATE TABLE #RsResultado (CD_EMP INT,
						   CD_FILIAL INT,
						   CD_PROD INT,
						   CD_PROC INT,
						   QT_EST MONEY,
						   QT_SAI_NF MONEY,
						   QT_SAI_PDV MONEY,
						   QT_EST_ENT_NF MONEY,
						   QT_EST_IMP MONEY,
						   QT_PEND_ENT MONEY,
						   QT_PEND_SAI MONEY)

declare @Dta date
set @Dta =dateadd(day,-1,@DT_CONTAGEM);

INSERT INTO #RsResultado
Select 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_EMP,
	V_EST_PROD_CPL_MOVIMENTACAO.CD_FILIAL, 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_PROD,
	EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_PROC, 
	P.QT_IT AS QT_EST, 
	ISNULL(SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_SAI_NF),0) AS QT_SAI_NF, 
	ISNULL(SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_SAI_PDV),0) AS QT_SAI_PDV, 
	ISNULL(SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_EST_ENT_NF),0) AS QT_EST_ENT_NF, 
	ISNULL(SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_EST_IMP), 0) As QT_EST_IMP,
	SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_PEND_ENT),
	SUM(V_EST_PROD_CPL_MOVIMENTACAO.QT_PEND_SAI)
From 
	V_EST_PROD_CPL_MOVIMENTACAO INNER JOIN EST_PROD_CRONO_CONTAGEM_EFET_PROC ON 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_PROD = EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_PROD AND 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_EMP = EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_EMP AND 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_FILIAL = EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_FILIAL 
	outer apply dbo.UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP,@CD_FILIAL,V_EST_PROD_CPL_MOVIMENTACAO.CD_PROD,@Dta,0) P 
Where 
	V_EST_PROD_CPL_MOVIMENTACAO.CD_EMP =@CD_EMP 
	AND V_EST_PROD_CPL_MOVIMENTACAO.CD_FILIAL =@CD_FILIAL
	AND EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_GRP_CONTAGEM =@CD_GRP_CONTAGEM 
	AND V_EST_PROD_CPL_MOVIMENTACAO.DT_MOV >=@DT_CONTAGEM
GROUP BY       
	V_EST_PROD_CPL_MOVIMENTACAO.CD_EMP,     
	V_EST_PROD_CPL_MOVIMENTACAO.CD_FILIAL,     
	V_EST_PROD_CPL_MOVIMENTACAO.CD_PROD, 
	EST_PROD_CRONO_CONTAGEM_EFET_PROC.CD_PROC,
	P.QT_IT

	update
		p
	set  
		p.QT_EST_INIC = r.QT_EST,
		p.QT_EST_SAI_NF = r.QT_SAI_NF,
		p.QT_EST_SAI_PDV = r.QT_SAI_PDV,
		p.QT_EST_ENT_NF = r.QT_EST_ENT_NF,
		p.QT_EST_IMP =r.QT_EST_IMP,
		P.QT_PEND_ENT=r.QT_PEND_ENT,
		P.QT_PEND_SAI=r.QT_PEND_SAI,
		p.STS_PROC = 1
	FROM 
		#RsResultado r INNER JOIN EST_PROD_CRONO_CONTAGEM_EFET_PROC p ON
		r.CD_EMP = p.CD_EMP AND
		r.CD_FILIAL = p.CD_FILIAL AND
		r.CD_PROC = p.CD_PROC AND
		r.CD_PROD = p.CD_PROD 

DROP TABLE #RsResultado;
